<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/settings/db.php';

if (!isset($_SESSION['memberId'])) {
    header("Location: home");
    exit;
}

$user_id = $_SESSION['memberId'];
$userCheckSite = $DB->prepare("SELECT * FROM users WHERE id = ?");
$userCheckSite->execute(array($user_id));
$userChk = $userCheckSite->fetch(PDO::FETCH_ASSOC);

$search = isset($_POST['search']) ? $_POST['search'] : '';

$categoryQuery = $DB->prepare("SELECT * FROM category WHERE ad LIKE ?");
$searchTerm = "%{$search}%";
$categoryQuery->execute(array($searchTerm));
$categories = $categoryQuery->fetchAll(PDO::FETCH_ASSOC);
?>

<?php foreach ($categories as $categoryData): ?>
<tr class="odd">
    <td class=" control" tabindex="0" style="display: none;"></td>
    <td class="sorting_1">
        <a class="fw-bold">#<?=$categoryData['id']?></a>
    </td>
    <td>
        <h6><?=$categoryData['ad']?></h6>
    </td>
    <td>
        <div class="d-flex">
            <?php if ($userChk['pcategoryEdit'] == '1' || $userChk['isAdmin'] == '1'): ?>
                <a href="category/<?=$categoryData['id']?>" class="btn btn-primary shadow btn-xs sharp me-1"><i data-feather="edit-2" class="feather-icon-edit"></i></a>
            <?php endif; ?>
            <?php if ($userChk['pcategoryDell'] == '1' || $userChk['isAdmin'] == '1'): ?>
                <a id="categoryDell" categoryID="<?=$categoryData['id']?>" class="categoryDell btn btn-danger shadow btn-xs sharp"><i data-feather="trash-2" class="feather-icon-trash"></i></a>
            <?php endif; ?>
        </div>
    </td>
</tr>
<?php endforeach; ?>
<script>feather.replace();</script>
